const config = require('../config/dbconfig');
const sql = require('mssql');

async function getlistcitas(fechainicio,fechafin) {
    try {
        const consulta = `
        SELECT ci.Fecha as fecha
        ,ci.HoraInicio + ' - ' + ci.HoraFin as hora
        ,se.Nombre as consultorio
        ,pa.PrimerNombre + ' ' + pa.ApellidoPaterno + ' ' + pa.ApellidoMaterno as paciente
        ,pa.NroDocumento as documento
        ,pa.NroHistoriaClinica as nro_historiaclinica
        ,pa.Telefono as paciente_celular
        ,em.Nombres + ' ' + em.ApellidoPaterno + ' ' + em.ApellidoMaterno as doctor
        ,es.Nombre as especialidad
        FROM sigh.dbo.Citas as ci
        inner join sigh.dbo.Pacientes as pa ON ci.IdPaciente = pa.IdPaciente
        inner join sigh.dbo.Servicios AS se ON ci.IdServicio = se.IdServicio
        inner join sigh.dbo.Especialidades as es ON ci.IdEspecialidad = es.IdEspecialidad
        inner join sigh.dbo.Medicos AS me ON ci.IdMedico = me.IdMedico
        inner join sigh.dbo.Empleados as em ON me.IdEmpleado = em.IdEmpleado
        where IdEstadoCita =  1 and pa.Telefono is NOT NULL and 
        ci.Fecha BETWEEN @input_parameter AND @input_parameter2`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, fechainicio)
        .input('input_parameter2', sql.VarChar, fechafin)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getcellularmissing(lafecha) {
    try {
        const consulta = `
        SELECT ci.Fecha as fecha
    ,ci.HoraInicio + ' - ' + ci.HoraFin as hora
    ,se.Nombre as consultorio
    ,pa.ApellidoPaterno + ' ' + pa.ApellidoMaterno + ' ' + pa.PrimerNombre as paciente
    ,pa.NroDocumento as documento
    ,pa.Telefono as celular
    ,pa.NroHistoriaClinica as nro_historiaclinica
    ,es.Nombre as especialidad
    ,em.Nombres + ' ' + em.ApellidoPaterno + ' ' + em.ApellidoMaterno as doctor
    ,empl.Nombres + ' ' + empl.ApellidoPaterno + ' ' + empl.ApellidoMaterno as gestor_de_atencion
    ,au.FechaHora as fecha_generacion
    FROM sigh.dbo.Citas as ci
    inner join sigh.dbo.Auditoria as au on ci.IdAtencion = au.IdRegistro
    inner join sigh.dbo.Empleados as empl on au.IdEmpleado = empl.IdEmpleado
    inner join sigh.dbo.Pacientes as pa ON ci.IdPaciente = pa.IdPaciente
    inner join sigh.dbo.Servicios AS se ON ci.IdServicio = se.IdServicio
    inner join sigh.dbo.Especialidades as es ON ci.IdEspecialidad = es.IdEspecialidad
    inner join sigh.dbo.Medicos AS me ON ci.IdMedico = me.IdMedico
    inner join sigh.dbo.Empleados as em ON me.IdEmpleado = em.IdEmpleado
    where ci.Fecha = @input_parameter and au.idListItem = 102 and au.Accion = 'A' and pa.Telefono is NULL
    order by especialidad, doctor desc`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, lafecha)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getcitaspaciente(estado,codigopaciente) {
    try {
        const consulta = `
        SELECT ci.IdCita as id
        ,ci.Fecha as fecha
        ,ci.HoraInicio + ' - ' + ci.HoraFin as hora
        ,se.Nombre as consultorio
        ,pa.ApellidoPaterno as paciente_apellidopaterno
        ,pa.ApellidoMaterno as paciente_apellidomaterno
        ,pa.PrimerNombre as paciente_primernombre
        ,pa.SegundoNombre as paciente_segundonombre
        ,pa.TercerNombre as paciente_tercernombre
        ,pa.NroDocumento as documento
        ,pa.NroHistoriaClinica as nro_historiaclinica
        ,pa.Telefono as paciente_celular
        ,em.ApellidoPaterno as doctor_apellidopaterno
        ,em.ApellidoMaterno as doctor_apellidomaterno 
        ,em.Nombres  as doctor_nombres
        ,es.Nombre as especialidad
        FROM sigh.dbo.Citas as ci
        inner join sigh.dbo.Pacientes as pa ON ci.IdPaciente = pa.IdPaciente
        inner join sigh.dbo.Servicios AS se ON ci.IdServicio = se.IdServicio
        inner join sigh.dbo.Especialidades as es ON ci.IdEspecialidad = es.IdEspecialidad
        inner join sigh.dbo.Medicos AS me ON ci.IdMedico = me.IdMedico
        inner join sigh.dbo.Empleados as em ON me.IdEmpleado = em.IdEmpleado
        where IdEstadoCita =  @input_parameter and ci.IdPaciente = @input_parameter2
        order by fecha desc;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, estado)
        .input('input_parameter2', sql.VarChar, codigopaciente)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getcita(codigo) {
    try {
        const consulta = `
        SELECT ci.IdCita as id
        ,ci.Fecha as fecha
        ,ci.HoraInicio + ' - ' + ci.HoraFin as hora
        ,se.Nombre as consultorio
        ,pa.ApellidoPaterno as paciente_apellidopaterno
        ,pa.ApellidoMaterno as paciente_apellidomaterno
        ,pa.PrimerNombre as paciente_primernombre
        ,pa.SegundoNombre as paciente_segundonombre
        ,pa.TercerNombre as paciente_tercernombre
        ,pa.NroDocumento as documento
        ,pa.NroHistoriaClinica as nro_historiaclinica
        ,pa.Telefono as paciente_celular
        ,em.ApellidoPaterno as doctor_apellidopaterno
        ,em.ApellidoMaterno as doctor_apellidomaterno
        ,em.Nombres  as doctor_nombres
        ,es.Nombre as especialidad
        FROM sigh.dbo.Citas as ci
        inner join sigh.dbo.Pacientes as pa ON ci.IdPaciente = pa.IdPaciente
        inner join sigh.dbo.Servicios AS se ON ci.IdServicio = se.IdServicio
        inner join sigh.dbo.Especialidades as es ON ci.IdEspecialidad = es.IdEspecialidad
        inner join sigh.dbo.Medicos AS me ON ci.IdMedico = me.IdMedico
        inner join sigh.dbo.Empleados as em ON me.IdEmpleado = em.IdEmpleado
        where ci.IdCita = @input_parameter;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.Int, codigo)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

module.exports = {
    getcitaspaciente: getcitaspaciente,
    getcita: getcita,
    getcellularmissing: getcellularmissing,
    getlistcitas: getlistcitas,
}
