const path = require('path');
const cors = require('cors');
const express = require('express');
const bodParser = require('body-parser');
const bodyParser = require('body-parser');

const app = express();

const citaRouter = require('./app/routes/cita.routes');
const pacienteRouter = require('./app/routes/paciente.routes');

app.use(bodyParser.urlencoded({extended: true}));
app.use(bodParser.json());
app.use(cors());
app.use(
  (req, res, next) => {
    // Website you wish to allow to connect
  res.setHeader('Access-Control-Allow-Origin', '*');
  // req.setHeader('Access-Control-Allow-Credentials', 'true');
  // Request methods you wish to allow
  res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
  // Request headers you wish to allow
  res.setHeader('Access-Control-Allow-Headers', 'Access-Control-Allow-Headers, Origin,Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers,X-Access-Token,XKey,Authorization');
  res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
  // Pass to next layer of middleware
  next();
  }
);

app.use('/', express.static(path.join(__dirname, 'public')));
// ruta de paciente
app.use('/api/paciente', pacienteRouter);
// ruta para las citas listado y detalle
app.use('/api/cita', citaRouter);

module.exports = app;