const dbpaciente = require('../models/dbpaciente');

exports.searchbydoc = async function (req, res) {
    try {
        const documento = req.params.doc;
        const fecha = req.params.fecha;
        dbpaciente.getpacientebydocumento(documento, fecha).then(
            result => {
                res.json(result[0]);
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.searchbydocsolo = async function (req, res) {
    try {
        const documento = req.params.doc;
        dbpaciente.getpacientebydocumentosolo(documento).then(
            result => {
                res.json(result[0]);
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.searchbyhisto = async function (req, res) {
    try {
        const historia = req.params.histo;
        const fecha = req.params.fecha;
        dbpaciente.getpacientebyhistoria(historia, fecha).then(
            result => {
                res.json(result[0]);
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.searchbyhistosolo = async function (req, res) {
    try {
        const historia = req.params.histo;
        dbpaciente.getpacientebyhistoriasolo(historia).then(
            result => {
                res.json(result[0]);
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}

exports.updatecelbyid = async function (req, res) {
    try {
        const codigo = req.params.id;
        const celular = req.params.cel;
        dbpaciente.updatecelular(
            codigo,
            celular
            ).then(
            result => {
                res.json(
                    {
                        respuesta: 'Gracias, El Hospital El Carmen se lo agradece'
                    }
                );
            }
        )
    } catch (err) {
        res.status(500).json(
            {
                error: err
            }
        );
    }
}
