const config = require('../config/dbconfig');
const sql = require('mssql');

async function getpacientebydocumento(codigo, fechita) {
    try {
        const consulta = `
        SELECT
        pa.IdPaciente as id,
        pa.ApellidoPaterno as apellidopaterno,
        pa.ApellidoMaterno as apellidomaterno,
        pa.PrimerNombre as primernombre,
        pa.SegundoNombre as segundonombre,
        pa.TercerNombre as tercernombre,
        pa.FechaNacimiento as fecha,
        pa.NroDocumento as documento,
        pa.Telefono as celular,
        pa.DireccionDomicilio as direcion,
        pa.NroHistoriaClinica as historiaclinica,
        pa.IdTipoSexo as genero
        FROM sigh.dbo.Pacientes as pa
        where pa.NroDocumento = @input_parameter
        and pa.FechaNacimiento = @input_parameterfecha;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, codigo)
        .input('input_parameterfecha', sql.VarChar, fechita)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getpacientebydocumentosolo(codigo) {
    try {
        const consulta = `
        SELECT
        pa.IdPaciente as id,
        pa.ApellidoPaterno as apellidopaterno,
        pa.ApellidoMaterno as apellidomaterno,
        pa.PrimerNombre as primernombre,
        pa.SegundoNombre as segundonombre,
        pa.TercerNombre as tercernombre,
        pa.FechaNacimiento as fecha,
        pa.NroDocumento as documento,
        pa.Telefono as celular,
        pa.DireccionDomicilio as direcion,
        pa.NroHistoriaClinica as historiaclinica,
        pa.IdTipoSexo as genero
        FROM sigh.dbo.Pacientes as pa
        where pa.NroDocumento = @input_parameter;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, codigo)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getpacientebyhistoria(codigo, fechita) {
    try {
        const consulta = `
        SELECT
        pa.IdPaciente as id,
        pa.ApellidoPaterno as apellidopaterno,
        pa.ApellidoMaterno as apellidomaterno,
        pa.PrimerNombre as primernombre,
        pa.SegundoNombre as segundonombre,
        pa.TercerNombre as tercernombre,
        pa.FechaNacimiento as fecha,
        pa.NroDocumento as documento,
        pa.Telefono as celular ,
        pa.DireccionDomicilio as direcion,
        pa.NroHistoriaClinica as historiaclinica,
        pa.IdTipoSexo as genero
        FROM sigh.dbo.Pacientes as pa
        where pa.NroHistoriaClinica = @input_parameter
        and pa.FechaNacimiento = @input_parameterfecha;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, codigo)
        .input('input_parameterfecha', sql.VarChar, fechita)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function getpacientebyhistoriasolo(codigo) {
    try {
        const consulta = `
        SELECT
        pa.IdPaciente as id,
        pa.ApellidoPaterno as apellidopaterno,
        pa.ApellidoMaterno as apellidomaterno,
        pa.PrimerNombre as primernombre,
        pa.SegundoNombre as segundonombre,
        pa.TercerNombre as tercernombre,
        pa.FechaNacimiento as fecha,
        pa.NroDocumento as documento,
        pa.Telefono as celular ,
        pa.DireccionDomicilio as direcion,
        pa.NroHistoriaClinica as historiaclinica,
        pa.IdTipoSexo as genero
        FROM sigh.dbo.Pacientes as pa
        where pa.NroHistoriaClinica = @input_parameter;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('input_parameter', sql.VarChar, codigo)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

async function updatecelular(codigo,celular) {
    try {
        const consulta = `
        UPDATE sigh.dbo.Pacientes
        SET Telefono = @parcelular
        WHERE IdPaciente = @paridentificador;`;
        let pool = await sql.connect(config);
        let paciente = await pool.request()
        .input('paridentificador', sql.Int, codigo)
        .input('parcelular', sql.VarChar, celular)
        .query(consulta);
        return paciente.recordsets;
    } catch (error) {
        console.log(error);
    }
}

module.exports = {
    getpacientebydocumento: getpacientebydocumento,
    getpacientebyhistoria: getpacientebyhistoria,
    getpacientebydocumentosolo: getpacientebydocumentosolo,
    getpacientebyhistoriasolo: getpacientebyhistoriasolo,
    updatecelular: updatecelular,
}
